/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import jclass.bwt.JCAdjustmentEvent;
import jclass.bwt.JCAdjustmentListener;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.JCScrollbar;
import jclass.bwt.ScrolledWindowConverter;
import jclass.bwt.Viewport;

public class JCScrolledWindow
extends JCContainer
implements KeyListener,
JCAdjustmentListener {
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    public static final int DISPLAY_NONE = 2;
    public static final int DISPLAY_VERTICAL_ONLY = 3;
    public static final int DISPLAY_HORIZONTAL_ONLY = 4;
    int sb_display = 0;
    int sb_offset;
    private JCScrollbar vert_sb = new JCScrollbar(1);
    private JCScrollbar horiz_sb = new JCScrollbar(0);
    int keystroke;
    private static final String base = "scrolledwindow";
    private static int nameCounter;
    protected Component viewport;
    protected boolean smartscroll = true;
    Rectangle rect = new Rectangle();

    public JCScrolledWindow() {
        this(null, null);
    }

    public JCScrolledWindow(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.setLayout(null);
        this.viewport = new Viewport();
        if (this.getClass().getName().equals("jclass.bwt.JCScrolledWindow")) {
            this.getParameters(applet);
        }
        this.addInternal(this.vert_sb);
        this.vert_sb.addAdjustmentListener(this);
        this.addInternal(this.horiz_sb);
        this.horiz_sb.addAdjustmentListener(this);
    }

    protected void getParameters() {
        super.getParameters();
        ScrolledWindowConverter.getParams(this);
    }

    public int getScrollbarDisplay() {
        return this.sb_display;
    }

    public void setScrollbarDisplay(int n) {
        ScrolledWindowConverter.checkDisplay(n);
        this.sb_display = n;
        this.layout();
    }

    public int getScrollbarOffset() {
        return this.sb_offset;
    }

    public void setScrollbarOffset(int n) {
        this.sb_offset = n;
        this.layout();
    }

    public boolean getSmartScroll() {
        return this.smartscroll;
    }

    public void setSmartScroll(boolean bl) {
        this.smartscroll = bl;
    }

    public Component getViewport() {
        return this.viewport;
    }

    int sb_size() {
        if (this.sb_display == 1) {
            return 16 + this.sb_offset;
        }
        return 0;
    }

    protected int preferredWidth() {
        int n;
        int n2 = n = this.viewport != null ? JCComponent.getPreferredSize((Component)this.viewport).width : 0;
        if (n > 0) {
            return n + this.sb_size();
        }
        return 100;
    }

    protected int preferredHeight() {
        int n;
        int n2 = n = this.viewport != null ? JCComponent.getPreferredSize((Component)this.viewport).height : 0;
        if (n > 0) {
            return n + this.sb_size();
        }
        return 100;
    }

    protected int getViewportWidth() {
        return JCComponent.getPreferredSize((Component)this.viewport).width;
    }

    protected int getViewportHeight() {
        return JCComponent.getPreferredSize((Component)this.viewport).height;
    }

    public Component add(Component component) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component);
        }
        return component;
    }

    public Component add(String string, Component component) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(string, component);
        }
        return component;
    }

    public Component add(Component component, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component, n);
        }
        return component;
    }

    public void add(Component component, Object object) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component, object);
        }
    }

    public void add(Component component, Object object, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component, object, n);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).add(component);
            if (!(component instanceof Container)) {
                component.addKeyListener(this);
            }
        }
    }

    protected void addInternal(Component component) {
        if (component.getParent() != this) {
            super.addImpl(component, null, -1);
        }
    }

    public void addNotify() {
        this.addInternal(this.viewport);
        super.addNotify();
    }

    public JCScrollbar getVertScrollbar() {
        return this.vert_sb;
    }

    public JCScrollbar getHorizScrollbar() {
        return this.horiz_sb;
    }

    protected void setHorizScrollbarValues() {
    }

    protected void setHorizScrollbarValues(int n, int n2, int n3, int n4) {
        n2 = Math.min(n4 - n3, n2);
        this.horiz_sb.setValues(n, n2, n3, n4);
        this.horiz_sb.setBlockIncrement(n2);
        this.horiz_sb.setUnitIncrement(10);
        this.setHorizScrollbarValues();
    }

    protected void setVertScrollbarValues(int n, int n2, int n3, int n4) {
        n2 = Math.min(n4 - n3, n2);
        this.vert_sb.setValues(n, n2, n3, n4);
        this.vert_sb.setBlockIncrement(n2);
        this.vert_sb.setUnitIncrement(10);
        this.setVertScrollbarValues();
    }

    protected void setVertScrollbarValues() {
    }

    protected int reshapeHeader(int n, int n2, int n3) {
        return 0;
    }

    protected int headerHeight() {
        return 0;
    }

    protected void reshapeViewport(int n, int n2, int n3, int n4) {
        JCComponent.setBounds(this.viewport, n, n2, n3, n4);
    }

    public void layout() {
        JCComponent jCComponent;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        boolean bl2;
        if (this.getPeer() == null) {
            return;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = this.headerHeight();
        n12 = this.getViewportWidth();
        n13 = this.getViewportHeight();
        JCScrolledWindow jCScrolledWindow = this;
        synchronized (jCScrolledWindow) {
            n8 = this.size().width - JCComponent.getInsets((Container)this).left - JCComponent.getInsets((Container)this).right;
            n9 = this.size().height - JCComponent.getInsets((Container)this).top - JCComponent.getInsets((Container)this).bottom;
            n10 = n9 - n14;
            n11 = n8;
            if (this.sb_display == 2) {
                bl2 = false;
                bl = false;
            } else if (this.sb_display == 1) {
                bl2 = true;
                bl = true;
            } else if (n10 >= n13 && n11 >= n12 && this.sb_display == 0) {
                n11 = n8;
                n10 = n9;
                bl2 = false;
                bl = false;
            } else {
                bl = this.sb_display != 4;
                bl2 = this.sb_display != 3;
                n5 = 1;
                n4 = 1;
                if (n13 <= n10 && this.sb_display != 3) {
                    n5 = 0;
                }
                if (n12 <= n11 && this.sb_display != 4) {
                    n4 = 0;
                }
                if (n4 != 0) {
                    n10 -= 16 + this.sb_offset;
                }
                if (n5 != 0) {
                    n11 -= 16 + this.sb_offset;
                }
                if (n13 <= n10 && this.sb_display != 3) {
                    n11 = n8;
                    bl = false;
                } else {
                    n11 = n8 - (16 + this.sb_offset);
                }
                if (n12 <= n11 && this.sb_display != 4) {
                    n10 = n9;
                    bl2 = false;
                } else {
                    n10 = n9 - (16 + this.sb_offset);
                }
            }
            n10 = bl2 ? n9 - (16 + this.sb_offset) : n9;
            int n15 = n11 = bl ? n8 - (16 + this.sb_offset) : n8;
            if (bl2) {
                n6 = !bl ? n8 : n11;
            }
            if (bl) {
                n7 = !bl2 ? n9 : n10;
            }
            n3 = JCComponent.getInsets((Container)this).left;
            n2 = JCComponent.getInsets((Container)this).top;
            int n16 = JCComponent.getInsets((Container)this).left;
            int n17 = bl2 ? this.size().height - JCComponent.getInsets((Container)this).bottom - 16 : this.size().height;
            int n18 = bl ? this.size().width - JCComponent.getInsets((Container)this).right - 16 : n8;
            int n19 = JCComponent.getInsets((Container)this).top;
        }
        int n20 = this.reshapeHeader(n3, n2, n11);
        int n21 = 0;
        n5 = 0;
        n4 = 0;
        Serializable serializable = this;
        synchronized (serializable) {
            n2 += n20;
            n19 += n20;
            n7 -= n20;
            n5 = n21 = this.vert_sb.getValue();
            n21 = Math.max(0, Math.min(n21, n13 - (n10 -= n20)));
            if (n21 != n5) {
                this.scrollVertical(null, n21);
            }
            n4 = n13;
            n = n10;
            if (this.viewport instanceof JCComponent) {
                jCComponent = (JCComponent)this.viewport;
                n20 = 2 * jCComponent.getBorderThickness() + jCComponent.getInsets().top + jCComponent.getInsets().bottom;
                n -= n20;
                n4 -= n20;
            }
        }
        this.setVertScrollbarValues(n21, n, 0, n4);
        serializable = this;
        synchronized (serializable) {
            n5 = n21 = this.horiz_sb.getValue();
            n21 = Math.max(0, Math.min(n21, n12 - n11));
            if (n21 != n5) {
                this.scrollHorizontal(null, n21);
            }
            n4 = n12;
            n = n11;
            if (this.viewport instanceof JCComponent) {
                jCComponent = (JCComponent)this.viewport;
                int n22 = 2 * jCComponent.getBorderThickness() + jCComponent.getInsets().left + jCComponent.getInsets().right;
                n -= n22;
                n4 -= n22;
            }
        }
        this.setHorizScrollbarValues(n21, n, 0, n4);
        this.reshapeViewport(n3, n2, n11, n10);
        serializable = this.viewport.location();
        Dimension dimension = this.viewport.size();
        if (bl) {
            JCComponent.setBounds(this.vert_sb, ((Point)serializable).x + dimension.width + this.sb_offset, ((Point)serializable).y, 16, n7);
        }
        this.vert_sb.show(bl);
        if (bl2) {
            JCComponent.setBounds(this.horiz_sb, ((Point)serializable).x, ((Point)serializable).y + dimension.height + this.sb_offset, n6, 16);
        }
        this.horiz_sb.show(bl2);
    }

    protected void scrollHorizontal(JCScrollableInterface jCScrollableInterface, JCAdjustmentEvent jCAdjustmentEvent, int n) {
        int n2 = n - jCScrollableInterface.getHorizOrigin();
        int n3 = Math.abs(n2);
        Component component = (Component)((Object)jCScrollableInterface);
        jCScrollableInterface.setHorizOrigin(n);
        if (component instanceof JCComponent) {
            ((JCComponent)component).getDrawingArea(this.rect);
        } else {
            this.rect.resize(component.size().width, component.size().height);
        }
        if (n3 >= this.rect.width) {
            component.repaint();
            return;
        }
        int n4 = this.rect.width - n3;
        JCComponent jCComponent = component instanceof JCComponent ? (JCComponent)component : null;
        Graphics graphics = component.getGraphics();
        if (jCComponent != null) {
            if (this.smartscroll) {
                jCComponent.copyArea(graphics, this.rect.x + Math.max(n2, 0), this.rect.y, n4, this.rect.height, -n2, 0);
                jCComponent.paintImmediately(this.rect.x + (n2 > 0 ? n4 : 0), this.rect.y, n3, this.rect.height);
            } else {
                jCComponent.paintImmediately(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
        } else if (this.smartscroll) {
            graphics.copyArea(this.rect.x + Math.max(n2, 0), this.rect.y, n4, this.rect.height, -n2, 0);
            component.repaint(this.rect.x + (n2 > 0 ? n4 : 0), this.rect.y, n3, this.rect.height);
        } else {
            component.repaint(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        graphics.dispose();
    }

    protected void scrollVertical(JCScrollableInterface jCScrollableInterface, JCAdjustmentEvent jCAdjustmentEvent, int n) {
        int n2 = n - jCScrollableInterface.getVertOrigin();
        int n3 = Math.abs(n2);
        Component component = (Component)((Object)jCScrollableInterface);
        jCScrollableInterface.setVertOrigin(n);
        if (component instanceof JCComponent) {
            ((JCComponent)component).getDrawingArea(this.rect);
        } else {
            this.rect.resize(component.size().width, component.size().height);
        }
        if (n3 >= this.rect.height) {
            component.repaint();
            return;
        }
        int n4 = this.rect.height - n3;
        JCComponent jCComponent = component instanceof JCComponent ? (JCComponent)component : null;
        Graphics graphics = component.getGraphics();
        if (jCComponent != null) {
            if (this.smartscroll) {
                jCComponent.copyArea(graphics, this.rect.x, this.rect.y + Math.max(n2, 0), this.rect.width, n4, 0, -n2);
                jCComponent.paintImmediately(this.rect.x, this.rect.y + (n2 > 0 ? n4 : 0), this.rect.width, n3);
            } else {
                jCComponent.paintImmediately(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
        } else if (this.smartscroll) {
            graphics.copyArea(this.rect.x, this.rect.y + Math.max(n2, 0), this.rect.width, n4, 0, -n2);
            component.repaint(this.rect.x, this.rect.y + (n2 > 0 ? n4 : 0), this.rect.width, n3);
        } else {
            component.repaint(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        }
        graphics.dispose();
    }

    protected void setScrollPosition(JCScrollableInterface jCScrollableInterface, int n, int n2) {
        int n3 = n - jCScrollableInterface.getHorizOrigin();
        int n4 = Math.abs(n3);
        int n5 = n2 - jCScrollableInterface.getVertOrigin();
        int n6 = Math.abs(n5);
        jCScrollableInterface.setHorizOrigin(n);
        jCScrollableInterface.setVertOrigin(n2);
        Component component = (Component)((Object)jCScrollableInterface);
        if (component instanceof JCComponent) {
            ((JCComponent)component).getDrawingArea(this.rect);
        } else {
            this.rect.resize(component.size().width, component.size().height);
        }
        if (n4 >= this.rect.width || n6 > this.rect.height) {
            component.repaint();
            return;
        }
        int n7 = this.rect.width - n4;
        int n8 = this.rect.height - n6;
        JCComponent jCComponent = component instanceof JCComponent ? (JCComponent)component : null;
        Graphics graphics = component.getGraphics();
        if (jCComponent != null) {
            jCComponent.copyArea(graphics, this.rect.x + Math.max(n3, 0), this.rect.y + Math.max(n5, 0), n7, n8, -n3, -n5);
            jCComponent.paintImmediately(n3 >= 0 && n5 >= 0 ? this.rect.x + n7 : this.rect.x, this.rect.y, n5 < 0 ? this.rect.width : n4, n5 < 0 ? n6 : n8);
            jCComponent.paintImmediately(n3 >= 0 && n5 < 0 ? this.rect.x + n7 : this.rect.x, n5 < 0 ? this.rect.y + n6 : this.rect.y + n8, n5 < 0 ? n4 : this.rect.width, n5 < 0 ? n8 : n6);
        } else {
            graphics.copyArea(this.rect.x + Math.max(n3, 0), this.rect.y + Math.max(n5, 0), n7, n8, -n3, -n5);
            component.repaint(n3 >= 0 && n5 >= 0 ? this.rect.x + n7 : this.rect.x, this.rect.y, n5 < 0 ? this.rect.width : n4, n5 < 0 ? n6 : n8);
            component.repaint(n3 >= 0 && n5 < 0 ? this.rect.x + n7 : this.rect.x, n5 < 0 ? this.rect.y + n6 : this.rect.y + n8, n5 < 0 ? n4 : this.rect.width, n5 < 0 ? n8 : n6);
        }
        graphics.dispose();
    }

    protected void scrollVertical(JCAdjustmentEvent jCAdjustmentEvent, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).scrollVertical(n);
            return;
        }
        if (this.viewport instanceof JCScrollableInterface) {
            this.scrollVertical((JCScrollableInterface)((Object)this.viewport), jCAdjustmentEvent, n);
        }
    }

    protected void scrollHorizontal(JCAdjustmentEvent jCAdjustmentEvent, int n) {
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).scrollHorizontal(n);
            return;
        }
        if (this.viewport instanceof JCScrollableInterface) {
            this.scrollHorizontal((JCScrollableInterface)((Object)this.viewport), jCAdjustmentEvent, n);
        }
    }

    public void scrollVertical(int n) {
        this.vert_sb.setValue(n);
        this.scrollVertical(null, this.vert_sb.getValue());
    }

    public void scrollHorizontal(int n) {
        this.horiz_sb.setValue(n);
        this.scrollHorizontal(null, this.horiz_sb.getValue());
    }

    public void setScrollPosition(int n, int n2) {
        this.horiz_sb.setValue(n);
        this.vert_sb.setValue(n2);
        if (this.viewport instanceof Viewport) {
            ((Viewport)this.viewport).scrollHorizontal(n);
            ((Viewport)this.viewport).scrollVertical(n2);
            return;
        }
        if (this.viewport instanceof JCScrollableInterface) {
            this.setScrollPosition((JCScrollableInterface)((Object)this.viewport), this.horiz_sb.getValue(), this.vert_sb.getValue());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: {
                this.keystroke = 1002;
                this.scrollVertical(this.vert_sb.getValue() - this.vert_sb.getBlockIncrement());
                break;
            }
            case 34: {
                this.keystroke = 1003;
                this.scrollVertical(this.vert_sb.getValue() + this.vert_sb.getBlockIncrement());
                break;
            }
            case 36: {
                this.keystroke = 1000;
                this.scrollVertical(0);
                break;
            }
            case 35: {
                this.keystroke = 1001;
                this.scrollVertical(this.vert_sb.getMaximum());
                break;
            }
            case 37: {
                this.keystroke = 1006;
                this.scrollHorizontal(this.horiz_sb.getValue() - this.horiz_sb.getUnitIncrement());
                break;
            }
            case 39: {
                this.keystroke = 1007;
                this.scrollHorizontal(this.horiz_sb.getValue() + this.horiz_sb.getUnitIncrement());
                break;
            }
        }
        this.keystroke = 0;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void adjustmentValueChanged(JCAdjustmentEvent jCAdjustmentEvent) {
        if (jCAdjustmentEvent.getSource() == this.vert_sb) {
            this.scrollVertical(jCAdjustmentEvent, this.vert_sb.getValue());
            return;
        }
        if (jCAdjustmentEvent.getSource() == this.horiz_sb) {
            this.scrollHorizontal(jCAdjustmentEvent, this.horiz_sb.getValue());
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }
}

